//
//  PTKeyCombo.h
//  Protein
//
//  Created by Quentin Carnicelli on Sat Aug 02 2003.
//  Copyright (c) 2003 Quentin D. Carnicelli. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface PTKeyCombo : NSObject <NSCopying>
{
	NSInteger	mKeyCode;
	NSUInteger	mModifiers;
}

+ (id)clearKeyCombo;
+ (id)keyComboWithKeyCode:(NSInteger)keyCode modifierFlags:(NSUInteger)modifierFlags;
- (id)initWithKeyCode:(NSInteger)keyCode modifierFlags:(NSUInteger)modifierFlags;

- (id)initWithPlistRepresentation:(id)plist;
- (id)plistRepresentation;

- (BOOL)isEqual:(PTKeyCombo *)combo;

- (NSInteger)keyCode;
- (NSUInteger)modifierFlags;

- (BOOL)isClearCombo;
- (BOOL)isValidHotKeyCombo;

@end

@interface PTKeyCombo (UserDisplayAdditions)
- (NSString *)keyCodeString;
@end
